
/*============================================================================
 Name        : libuserCmd.h
 Author      :
 Date  	     : 2015.9
 Copyright   : ZKSoftware Inc.
 Description : Linux C
 ============================================================================*/

#ifndef _LIBUSERCMD_H_
#define _LIBUSERCMD_H_

int Connect(char *dev, int type);
int Final(void);
int Disconnect(void);
int Reset(void);
int DisableDevice(void);
int EnableDevice(void);
int Upgrade (unsigned char *fw, int size);
/**************************** User command *******************************/
int EnrollUserByScan(int userID);
int EnrollTemplateByImage(int userID, unsigned char * data, int dataSize);
int GetFingerImage(int *width, int *heigth, unsigned char *data);
int IdentifyByImage(int imageSize, int *userID, int *index, unsigned char * data);
int ClearDB(void);
int ReadAllLogs(int *userID,  char *event, char *verified,
		unsigned long *date, unsigned long *time, char *reserved);
int GetAllLogs(int *dataSize);
int SetTime(int Year, int Month, int Day,  int Hour, int Minute, int Second);
int GetTime(int *Year, int *Month, int *Day,  int *Hour, int *Minute, int *Second);
int GetStatus(void);
int GetParameter(int flag, int *value);
int SetParameter(int value, int flag);
int SaveParameter(void);
int DeleteAllUsers(void);
int DeleteUser(int userID);
int ReadAllUser(int *userID,  char *name,  char *password, unsigned short *secLevel,
		unsigned long *PIN2, unsigned char *privilege,
		unsigned char *fingerprintNum, unsigned char *Card);
int GetAllUsers(int *dataSize);
int GetUser(int userID,  char *name,  char *password, unsigned short *secLevel,
		unsigned long *PIN2, unsigned char *privilege,
		unsigned char *fingerprintNum, unsigned char *Card);
int ModifyUser(int userID,  char *name,  char *password, unsigned short secLevel,
		unsigned long PIN2, unsigned char privilege,
		unsigned char fingerprintNum, U8 *Card);
int SetTemplates(int userID, int flag, unsigned char *data, int dataSize);
int DeleteTemplates(int userID, int index, int flag);
int DeleteAllTemplates (void);
int ReadTemplates(int userID, int index,  int flag, unsigned char *data);
int GetTemplates(int userID, int index,  int flag, int *dataSize);
int ReadAllTemplates(unsigned char *data);
int GetAllTemplates(int *dataSize);
int Verify(int userID);
int DeleteAllLogs(void);
int AutoDubug(void);
void TimeAnalyse(unsigned long date, unsigned long time,
		int *Year, int *Month, int *Day,  int *Hour, int *Minute, int *Second);
int ScanTemplate(unsigned char *data);
/************************** User info **********************/
typedef struct _User_
{
	U16 userID;		//User ID
	U8 Privilege;
	U8 Fpnum;		//figerprintNum
	U16 SecLevel;	//Encryption level :0 1 11
	U32 PIN2;		//User identification number
	char Name[8];
	char Password[5];
	U8 Card[5];		//CardID num
}GCC_PACKED tUser, *pUser;

typedef struct _Log_
{
	char  Event;
	char  verified;
	U32    Date;
	U32    Time;
	U16    userID;
	char   Reserved[4];
}GCC_PACKED tLog, *pLog;

/****************************** save and read image ********************************/
void save_bmp(unsigned char *buffer, signed long Width, signed long Height);
int WriteBitmap(unsigned char *buffer, signed long Width, signed long Height, char * FileName);
int read_image(char *filename, unsigned char *data);

#endif /* _LIBUSERCMD_H_ */
